% This is the main of the Genetic Feature Selection Toolbox. It should be
% used after a training set has been computed by the Localization And 
% Feature Extraction. It reads the segmented images of the 13 regions in
% the folder IMAGES_FOLDER and generates the features in FEATURES_FOLDER.
% Then, it launches a genetic algorithm to find the features that maximize
% the difference between the group identify by the label TARGET_GROUP and
% the others. These labels are read in LABELS_FILE. This file should
% indicate, for each row, the lable of the corresponding gene (see
% GENES_FILE after it has been created)

close all

%% INITIALIZATION

addpath('functions/')

% regions of the hippocampus to analyze (DO NOT CHANGE THIS)
PARTS    = {'ca1_border_int','ca1_border_ext','ca1_in','ca1_out',...
             'ca3_border_int','ca3_border_ext','ca3_in','ca3_out',...
             'dg_border_int','dg_border_ext','dg_in','dg_out_int','dg_out_ext'};
FEATURES = {'Mean', 'StdDev',  'cv', 'Skewness', 'Kurtosis', 'Energy', 'Entropy', 'Contrast', 'Correlation', 'Energy2', 'Homogeneity'};

if ~exist('RUNNING_ENTIRE_EXPERIMENT', 'var')
    %% SET folder where images reside (same as OUTPUT_FOLDER in COMPUTE_GENE_LIST)
    OUTPUT_FOLDER = 'C:/Users/Roberto/Desktop/SanPaolo/experiments';
    %% SET database to use
    EXPERIMENT = 'example';
    %% SET file containing the genes to compute
    FILE_GENES = strcat(OUTPUT_FOLDER,'/',EXPERIMENT,'.train');
else
    disp('mainFeatureExtraction has been called from outside. Some parameters may be overwritten')
end
EXPERIMENT_FOLDER = strcat(OUTPUT_FOLDER, '/', EXPERIMENT, '/train');

%% SET whether to extract features from images
GENERATE_FEATURES = 1;

%% SET whether to remove feature very correlated (default 1)
REMOVE_SIMILAR_FEATURES = 1;
%% SET remove features with a correlation bigger than MIN_CORRELATION (default 0.99)
MIN_CORRELATION = 0.99;

%% SET the identifier for the target group
TARGET_GROUP = 1;

%% SET a fetures is eventually selected if it wins at least MIN_WINNING_FEATURES*100% of the times (default 0.5)
MIN_WINNING_FEATURES = 0.5;


FEATURES_FOLDER = strcat(EXPERIMENT_FOLDER, '/training_features');
IMAGES_FOLDER   = strcat(EXPERIMENT_FOLDER, '/segmented');
OUT_GENES_FILE  = strcat(EXPERIMENT_FOLDER, '/training_genes.txt');
LABELS_FILE     = strcat(EXPERIMENT_FOLDER, '/../../',EXPERIMENT,'.labels');

%% EXECUTION

%read images containing segmented parts and generate features for training
if GENERATE_FEATURES
    disp('READING IMAGES AND GENERATING FEATURES...')
    extractFeaturesFromImages
%     fprintf('A new labels file has been generated in %s/labels_%s.txt.\n', EXPERIMENT_FOLDER, EXPERIMENT)
%     input('Press RETURN when you finish modified it!')
end

%read all data
disp('READING FEATURES FROM FILE...')
read_data

%if the user wants, remove redundant features
if REMOVE_SIMILAR_FEATURES
    disp('REMOVING USELESS FEATURES...')
    remove_similar_features
else
    DATA = COMPLETE_DATA;
    TO_KEEP = zeros(1,NUM_FEATURES);
end

%load labels from file
load_labels

%launch optimization
disp('LAUNCH GENETIC SELECTION OF FEATURES...')
launch_ga

FINAL_FEATURES = SELECTED_FEATURES>MIN_WINNING_FEATURES*max(SELECTED_FEATURES);

%print information about selected features...
print_features

%show results on training set
disp('TESTING SELECTED FEATURES...')
test_features

    
%save .mat file with all the information needed for ranking
disp('SAVE FINAL RESULTS INTO MAT FILE...')
selected_features = FINAL_FEATURES;
mymu              = MU;
mysigma           = SIGMA;
prototype         = AVG_CLASS;
save(strcat(EXPERIMENT_FOLDER,'/ranking_variables.mat'), 'selected_features', 'mymu', 'mysigma', 'prototype');
